--from 1.9.6
--from 1.9.7
UPDATE access_rules SET name='(AccessRule automatically created for Group 1)' WHERE id=1;
--Notar que apenas essa AccessRule será renomeada, já que vem no criarbanco.sql. Qualquer outra que tenha sido
--criada automaticamente continuará com o nome antigo. Não há, porém, alteração de funcionalidade, segundo JP.

--from 1.9.8
CREATE TRIGGER prevent_insert_default_group BEFORE INSERT ON groups WHEN NEW.id = 1 BEGIN SELECT RAISE(IGNORE); END;
CREATE TRIGGER prevent_insert_default_time_zone BEFORE INSERT ON time_zones WHEN NEW.id = 1 BEGIN SELECT RAISE(IGNORE); END;
CREATE TRIGGER prevent_insert_default_time_span BEFORE INSERT ON time_spans WHEN NEW.id = 1 BEGIN SELECT RAISE(IGNORE); END;
CREATE TRIGGER prevent_update_default_group BEFORE UPDATE ON groups WHEN OLD.id = 1 BEGIN SELECT RAISE(ABORT, 'Unable to update default group'); END;
CREATE TRIGGER prevent_update_default_time_zone BEFORE UPDATE ON time_zones WHEN OLD.id = 1 BEGIN SELECT RAISE(ABORT, 'Unable to update default time_zone'); END;
CREATE TRIGGER prevent_update_default_time_span BEFORE UPDATE ON time_spans WHEN OLD.id = 1 BEGIN SELECT RAISE(ABORT, 'Unable to update default time_span'); END;
CREATE TRIGGER prevent_delete_default_group BEFORE DELETE ON groups WHEN OLD.id = 1 BEGIN SELECT RAISE(ABORT, 'Unable to delete default group'); END;
CREATE TRIGGER prevent_delete_default_time_zone BEFORE DELETE ON time_zones WHEN OLD.id = 1 BEGIN SELECT RAISE(ABORT, 'Unable to delete default time_zone'); END;
CREATE TRIGGER prevent_delete_default_time_span BEFORE DELETE ON time_spans WHEN OLD.id = 1 BEGIN SELECT RAISE(ABORT, 'Unable to delete default time_span'); END;

--from 1.9.9
UPDATE portals SET name='Entrada' WHERE id=-1;
INSERT INTO portals VALUES(-2, 'Saída', 2, 1);
UPDATE identification_rules SET "parameters"='portal_in=-1|portal_out=-2|identifier_source_1=win|identifier_source_2=mag';
INSERT INTO portal_actions VALUES(-2, 1);
INSERT INTO portal_actions VALUES(-2, 2);
INSERT INTO portal_access_rules VALUES(-2, 1);

--from 1.9.10
CREATE INDEX access_logs_time_idx ON access_logs(time);

--from 1.9.11
--from 1.9.12
--from 1.9.13
--from 2.0.0
--from 2.0.4
--from 2.1.0

ALTER TABLE waiting_room_rules RENAME TO portal_rules;

CREATE TABLE portal_portal_rules (portal_id INTEGER NOT NULL REFERENCES portals(id) ON DELETE CASCADE, portal_rule_id INTEGER NOT NULL REFERENCES portal_rules(id) ON DELETE CASCADE, UNIQUE(portal_id, portal_rule_id));
INSERT INTO portal_portal_rules (portal_id, portal_rule_id) SELECT portal_id, waiting_room_rule_id FROM portal_waiting_room_rules;
DROP TABLE portal_waiting_room_rules;

CREATE TABLE portal_rule_groups (portal_rule_id INTEGER NOT NULL REFERENCES portal_rules(id) ON DELETE CASCADE, group_id INTEGER NOT NULL REFERENCES groups(id) ON DELETE CASCADE, quantity INTEGER NOT NULL, UNIQUE(portal_rule_id, group_id));
INSERT INTO portal_rule_groups (portal_rule_id, group_id, quantity) SELECT waiting_room_rule_id, group_id, quantity FROM waiting_room_rule_groups;
DROP TABLE waiting_room_rule_groups;

CREATE TABLE portal_rule_users (portal_rule_id INTEGER NOT NULL REFERENCES portal_rules(id) ON DELETE CASCADE, user_id INTEGER NOT NULL REFERENCES users(id) ON DELETE CASCADE ON UPDATE CASCADE, UNIQUE(portal_rule_id, user_id));
INSERT INTO portal_rule_users (portal_rule_id, user_id) SELECT waiting_room_rule_id, user_id FROM waiting_room_rule_users;
DROP TABLE waiting_room_rule_users;

CREATE TABLE portal_rule_actions (portal_rule_id INTEGER NOT NULL REFERENCES portal_rules(id) ON DELETE CASCADE, action_id INTEGER NOT NULL REFERENCES actions(id) ON DELETE CASCADE, UNIQUE(portal_rule_id, action_id));
INSERT INTO portal_rule_actions (portal_rule_id, action_id) SELECT waiting_room_rule_id, action_id FROM waiting_room_rule_actions;
DROP TABLE waiting_room_rule_actions;

CREATE TABLE portal_rule_validations (portal_rule_id INTEGER NOT NULL REFERENCES portal_rules(id) ON DELETE CASCADE, validation_id INTEGER NOT NULL REFERENCES validations(id) ON DELETE CASCADE, UNIQUE(portal_rule_id, validation_id));
INSERT INTO portal_rule_validations (portal_rule_id, validation_id) SELECT waiting_room_rule_id, validation_id FROM waiting_room_rule_validations;
DROP TABLE waiting_room_rule_validations;

CREATE TABLE portal_rule_time_zones (portal_rule_id INTEGER NOT NULL REFERENCES portal_rules(id) ON DELETE CASCADE, time_zone_id INTEGER NOT NULL REFERENCES time_zones(id) ON DELETE CASCADE, UNIQUE(portal_rule_id, time_zone_id));
INSERT INTO portal_rule_time_zones (portal_rule_id, time_zone_id) SELECT waiting_room_rule_id, time_zone_id FROM waiting_room_rule_time_zones;
DROP TABLE waiting_room_rule_time_zones;

CREATE TABLE access_log_portal_rules (access_log_id INTEGER NOT NULL REFERENCES access_logs(id) ON DELETE CASCADE, portal_rule_id INTEGER NOT NULL REFERENCES portal_rules(id), UNIQUE(access_log_id, portal_rule_id));
INSERT INTO access_log_portal_rules (access_log_id, portal_rule_id) SELECT access_log_id, waiting_room_rule_id FROM access_log_waiting_room_rules;
DROP TABLE access_log_waiting_room_rules;

DROP TRIGGER prevent_update_default_group;

--from 2.2.0
--from 2.2.1
--from 2.2.2
--from 2.3.0
--from 2.3.1
--from 2.3.2

ALTER TABLE cards RENAME TO cards_old;
CREATE TABLE cards (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, value BIGINT UNIQUE NOT NULL, user_id INTEGER NOT NULL REFERENCES users(id) ON DELETE CASCADE ON UPDATE CASCADE);
INSERT INTO cards (id, value, user_id) SELECT id, value, user_id FROM cards_old;
DROP TABLE cards_old;

ALTER TABLE access_logs RENAME TO access_logs_old;
CREATE TABLE access_logs (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, time INTEGER NOT NULL, event INTEGER NOT NULL, equipment_id BIGINT, identifier_id INTEGER, user_id BIGINT, portal_id BIGINT, identification_rule_id BIGINT);
INSERT INTO access_logs (id, time, event, equipment_id, identifier_id, user_id, portal_id, identification_rule_id) SELECT id, time, event, equipment_id, identifier_id, user_id, portal_id, identification_rule_id FROM access_logs_old;
DROP TABLE access_logs_old;

ALTER TABLE alarm_logs RENAME TO alarm_logs_old;
CREATE TABLE alarm_logs (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, event INTEGER NOT NULL, cause INTEGER NOT NULL, user_id BIGINT, time INTEGER NOT NULL);
INSERT INTO alarm_logs (id, event, cause, user_id, time) SELECT id, event, cause, user_id, time FROM alarm_logs_old;
DROP TABLE alarm_logs_old;

CREATE TABLE reports (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, name TEXT NOT NULL, file_name TEXT NOT NULL, object TEXT NOT NULL, header TEXT NOT NULL, delimiter TEXT NOT NULL, line_break TEXT NOT NULL);

CREATE TABLE report_columns (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, report_id INTEGER NOT NULL REFERENCES reports(id) ON DELETE CASCADE, type INTEGER NOT NULL, sequence INTEGER NOT NULL);

CREATE TABLE object_field_report_columns (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, report_column_id INTEGER NOT NULL REFERENCES report_columns(id) ON DELETE CASCADE, object TEXT NOT NULL, field TEXT NOT NULL);

CREATE TABLE counter_report_columns (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, report_column_id INTEGER NOT NULL REFERENCES report_columns(id) ON DELETE CASCADE, offset INTEGER NOT NULL, step INTEGER NOT NULL);

CREATE TABLE fixed_report_columns (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, report_column_id INTEGER NOT NULL REFERENCES report_columns(id) ON DELETE CASCADE, fixed TEXT NOT NULL);

CREATE TABLE report_column_formats (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, report_column_id INTEGER NOT NULL REFERENCES report_columns(id) ON DELETE CASCADE, adjustment INTEGER NOT NULL, width INTEGER NOT NULL, fill TEXT NOT NULL, format TEXT NOT NULL);

CREATE TABLE report_filters (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, report_id INTEGER NOT NULL REFERENCES reports(id) ON DELETE CASCADE, object TEXT NOT NULL, field TEXT NOT NULL, value TEXT NOT NULL, visible INTEGER NOT NULL DEFAULT 1, editable INTEGER NOT NULL DEFAULT 1);

INSERT INTO reports VALUES(1,'Acessos (Global)','','access_logs','Data e Hora (Logs de Acesso);Autorização (Logs de Acesso);Código (Usuário);Nome (Usuário);Matrícula (Usuário);Nome (Portal);Nome (Horário)',';','\r\n');
INSERT INTO reports VALUES(2,'Acessos por Usuário','','access_logs','Data e Hora (Logs de Acesso);Autorização (Logs de Acesso);Código (Usuário);Nome (Usuário);Matrícula (Usuário);Nome (Portal);Nome (Horário)',';','\r\n');
INSERT INTO reports VALUES(3,'Acessos por Horário','','access_logs','Data e Hora (Logs de Acesso);Autorização (Logs de Acesso);Código (Usuário);Nome (Usuário);Matrícula (Usuário);Nome (Horário)',';','\r\n');
INSERT INTO reports VALUES(4,'Acessos por Departamento','','access_logs','Data e Hora (Logs de Acesso);Autorização (Logs de Acesso);Código (Usuário);Nome (Usuário);Matrícula (Usuário);Nome (Portal);Nome (Horário)',';','\r\n');
INSERT INTO reports VALUES(5,'Usuários','','users','Código (Usuário);Nome (Usuário);Matrícula (Usuário);Nome (Departamento);Administrador (Direito)',';','\r\n');

INSERT INTO report_columns VALUES(1,1,3,0);
INSERT INTO report_columns VALUES(2,1,3,1);
INSERT INTO report_columns VALUES(3,1,3,2);
INSERT INTO report_columns VALUES(4,1,3,3);
INSERT INTO report_columns VALUES(5,1,3,4);
INSERT INTO report_columns VALUES(6,1,3,5);
INSERT INTO report_columns VALUES(7,1,3,6);
INSERT INTO report_columns VALUES(8,2,3,0);
INSERT INTO report_columns VALUES(9,2,3,1);
INSERT INTO report_columns VALUES(10,2,3,2);
INSERT INTO report_columns VALUES(11,2,3,3);
INSERT INTO report_columns VALUES(12,2,3,4);
INSERT INTO report_columns VALUES(13,2,3,5);
INSERT INTO report_columns VALUES(14,2,3,6);
INSERT INTO report_columns VALUES(15,3,3,0);
INSERT INTO report_columns VALUES(16,3,3,1);
INSERT INTO report_columns VALUES(17,3,3,2);
INSERT INTO report_columns VALUES(18,3,3,3);
INSERT INTO report_columns VALUES(19,3,3,4);
INSERT INTO report_columns VALUES(20,3,3,5);
INSERT INTO report_columns VALUES(21,4,3,0);
INSERT INTO report_columns VALUES(22,4,3,1);
INSERT INTO report_columns VALUES(23,4,3,2);
INSERT INTO report_columns VALUES(24,4,3,3);
INSERT INTO report_columns VALUES(25,4,3,4);
INSERT INTO report_columns VALUES(26,4,3,5);
INSERT INTO report_columns VALUES(27,4,3,6);
INSERT INTO report_columns VALUES(28,5,3,0);
INSERT INTO report_columns VALUES(29,5,3,1);
INSERT INTO report_columns VALUES(30,5,3,2);
INSERT INTO report_columns VALUES(31,5,3,3);
INSERT INTO report_columns VALUES(32,5,3,4);

INSERT INTO object_field_report_columns VALUES(1,1,'access_logs','time');
INSERT INTO object_field_report_columns VALUES(2,2,'access_logs','event');
INSERT INTO object_field_report_columns VALUES(3,3,'users','id');
INSERT INTO object_field_report_columns VALUES(4,4,'users','name');
INSERT INTO object_field_report_columns VALUES(5,5,'users','registration');
INSERT INTO object_field_report_columns VALUES(6,6,'portals','name');
INSERT INTO object_field_report_columns VALUES(7,7,'time_zones','name');
INSERT INTO object_field_report_columns VALUES(8,8,'access_logs','time');
INSERT INTO object_field_report_columns VALUES(9,9,'access_logs','event');
INSERT INTO object_field_report_columns VALUES(10,10,'users','id');
INSERT INTO object_field_report_columns VALUES(11,11,'users','name');
INSERT INTO object_field_report_columns VALUES(12,12,'users','registration');
INSERT INTO object_field_report_columns VALUES(13,13,'portals','name');
INSERT INTO object_field_report_columns VALUES(14,14,'time_zones','name');
INSERT INTO object_field_report_columns VALUES(15,15,'access_logs','time');
INSERT INTO object_field_report_columns VALUES(16,16,'access_logs','event');
INSERT INTO object_field_report_columns VALUES(17,17,'users','id');
INSERT INTO object_field_report_columns VALUES(18,18,'users','name');
INSERT INTO object_field_report_columns VALUES(19,19,'users','registration');
INSERT INTO object_field_report_columns VALUES(20,20,'time_zones','name');
INSERT INTO object_field_report_columns VALUES(21,21,'access_logs','time');
INSERT INTO object_field_report_columns VALUES(22,22,'access_logs','event');
INSERT INTO object_field_report_columns VALUES(23,23,'users','id');
INSERT INTO object_field_report_columns VALUES(24,24,'users','name');
INSERT INTO object_field_report_columns VALUES(25,25,'users','registration');
INSERT INTO object_field_report_columns VALUES(26,26,'portals','name');
INSERT INTO object_field_report_columns VALUES(27,27,'time_zones','name');
INSERT INTO object_field_report_columns VALUES(28,28,'users','id');
INSERT INTO object_field_report_columns VALUES(29,29,'users','name');
INSERT INTO object_field_report_columns VALUES(30,30,'users','registration');
INSERT INTO object_field_report_columns VALUES(31,31,'groups','name');
INSERT INTO object_field_report_columns VALUES(32,32,'user_roles','role');

INSERT INTO report_column_formats VALUES(1,1,0,0,'0','%d/%m/%Y %H:%M:%S');
INSERT INTO report_column_formats VALUES(2,2,1,1,'0','');
INSERT INTO report_column_formats VALUES(3,3,2,5,'0','');
INSERT INTO report_column_formats VALUES(4,4,1,50,' ','');
INSERT INTO report_column_formats VALUES(5,5,1,50,' ','');
INSERT INTO report_column_formats VALUES(6,6,1,50,' ','');
INSERT INTO report_column_formats VALUES(7,7,1,50,' ','');
INSERT INTO report_column_formats VALUES(8,8,0,0,'0','%d/%m/%Y %H:%M:%S');
INSERT INTO report_column_formats VALUES(9,9,1,1,'0','');
INSERT INTO report_column_formats VALUES(10,10,2,5,'0','');
INSERT INTO report_column_formats VALUES(11,11,1,50,' ','');
INSERT INTO report_column_formats VALUES(12,12,1,50,' ','');
INSERT INTO report_column_formats VALUES(13,13,1,50,' ','');
INSERT INTO report_column_formats VALUES(14,14,1,50,' ','');
INSERT INTO report_column_formats VALUES(15,15,0,0,'0','%d/%m/%Y %H:%M:%S');
INSERT INTO report_column_formats VALUES(16,16,1,1,'0','');
INSERT INTO report_column_formats VALUES(17,17,2,5,'0','');
INSERT INTO report_column_formats VALUES(18,18,1,50,' ','');
INSERT INTO report_column_formats VALUES(19,19,1,50,' ','');
INSERT INTO report_column_formats VALUES(20,20,1,50,' ','');
INSERT INTO report_column_formats VALUES(21,21,0,0,'0','%d/%m/%Y %H:%M:%S');
INSERT INTO report_column_formats VALUES(22,22,1,1,'0','');
INSERT INTO report_column_formats VALUES(23,23,2,5,'0','');
INSERT INTO report_column_formats VALUES(24,24,1,50,' ','');
INSERT INTO report_column_formats VALUES(25,25,1,50,' ','');
INSERT INTO report_column_formats VALUES(26,26,1,50,' ','');
INSERT INTO report_column_formats VALUES(27,27,1,50,' ','');
INSERT INTO report_column_formats VALUES(28,28,2,5,'0','');
INSERT INTO report_column_formats VALUES(29,29,1,50,' ','');
INSERT INTO report_column_formats VALUES(30,30,1,50,' ','');
INSERT INTO report_column_formats VALUES(31,31,1,50,' ','');
INSERT INTO report_column_formats VALUES(32,32,1,1,' ','');

INSERT INTO report_filters VALUES(1,1,'access_logs','time','{"type":"day","interval":29,"finish":0}',1,1);
INSERT INTO report_filters VALUES(3,1,'users','id','',1,1);
INSERT INTO report_filters VALUES(4,1,'portals','id','',1,1);
INSERT INTO report_filters VALUES(5,1,'groups','id','',1,1);
INSERT INTO report_filters VALUES(6,1,'time_zones','id','',1,1);
INSERT INTO report_filters VALUES(7,2,'access_logs','event','',1,1);
INSERT INTO report_filters VALUES(8,2,'access_logs','time','{"type":"day","interval":29,"finish":0}',1,1);
INSERT INTO report_filters VALUES(9,2,'users','id','',1,1);
INSERT INTO report_filters VALUES(10,2,'portals','id','',0,0);
INSERT INTO report_filters VALUES(11,2,'groups','id','',0,0);
INSERT INTO report_filters VALUES(12,2,'time_zones','id','',1,1);
INSERT INTO report_filters VALUES(13,3,'access_logs','event','',1,1);
INSERT INTO report_filters VALUES(14,3,'access_logs','time','{"type":"day","interval":29,"finish":0}',1,1);
INSERT INTO report_filters VALUES(15,3,'users','id','',0,1);
INSERT INTO report_filters VALUES(16,3,'portals','id','',0,1);
INSERT INTO report_filters VALUES(17,3,'groups','id','',0,1);
INSERT INTO report_filters VALUES(18,3,'time_zones','id','',1,1);
INSERT INTO report_filters VALUES(19,4,'access_logs','event','',1,1);
INSERT INTO report_filters VALUES(20,4,'access_logs','time','{"type":"day","interval":29,"finish":0}',1,1);
INSERT INTO report_filters VALUES(21,4,'users','id','',0,1);
INSERT INTO report_filters VALUES(22,4,'portals','id','',0,1);
INSERT INTO report_filters VALUES(23,4,'groups','id','',1,1);
INSERT INTO report_filters VALUES(24,4,'time_zones','id','',0,1);
INSERT INTO report_filters VALUES(25,5,'users','id','',1,1);
INSERT INTO report_filters VALUES(26,5,'groups','id','',1,1);
INSERT INTO report_filters VALUES(27,5,'user_roles','role','',1,1);
INSERT INTO report_filters VALUES(28,5,'time_zones','id','',1,1);

--from 2.3.3
--from 2.3.4
--from 2.3.90
--from 2.3.91

ALTER TABLE access_log_access_rules RENAME TO access_log_access_rules_old;
CREATE TABLE access_log_access_rules (access_log_id INTEGER NOT NULL REFERENCES access_logs(id) ON DELETE CASCADE, access_rule_id INTEGER NOT NULL REFERENCES access_rules(id) ON DELETE CASCADE, UNIQUE(access_log_id, access_rule_id));
INSERT INTO access_log_access_rules (access_log_id, access_rule_id) SELECT access_log_id, access_rule_id FROM access_log_access_rules_old;
DROP TABLE access_log_access_rules_old;

ALTER TABLE access_log_portal_rules RENAME TO access_log_portal_rules_old;
CREATE TABLE access_log_portal_rules (access_log_id INTEGER NOT NULL REFERENCES access_logs(id) ON DELETE CASCADE, portal_rule_id INTEGER NOT NULL REFERENCES portal_rules(id) ON DELETE CASCADE, UNIQUE(access_log_id, portal_rule_id));
INSERT INTO access_log_portal_rules (access_log_id, portal_rule_id) SELECT access_log_id, portal_rule_id FROM access_log_portal_rules_old;
DROP TABLE access_log_portal_rules_old;

--from 2.4.0
--from 2.4.1
--from 2.4.2
--from 2.4.3
--from 2.4.4
--from 2.4.5
--from 2.4.6
--from 2.4.7

ALTER TABLE users ADD COLUMN expires INTEGER;

DROP TABLE identification_rules;
CREATE TABLE identification_rules (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, name TEXT NOT NULL, script_instance_id INTEGER NOT NULL REFERENCES script_instances(id) ON DELETE CASCADE);

CREATE TABLE area_access_rules (area_id INTEGER NOT NULL REFERENCES areas(id) ON DELETE CASCADE, access_rule_id INTEGER NOT NULL REFERENCES access_rules(id) ON DELETE CASCADE, UNIQUE(area_id, access_rule_id));

CREATE TABLE new_access_logs (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, time INTEGER NOT NULL, event INTEGER NOT NULL, device_id BIGINT, identifier_id INTEGER, user_id BIGINT, portal_id BIGINT, identification_rule_id BIGINT);
INSERT INTO new_access_logs (id, time, event, device_id, identifier_id, user_id, portal_id, identification_rule_id) SELECT id, time, event, equipment_id, identifier_id, user_id, portal_id, identification_rule_id FROM access_logs;
DROP TABLE access_logs;
ALTER TABLE new_access_logs RENAME TO access_logs;

CREATE TABLE devices (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, name TEXT NOT NULL, ip TEXT NOT NULL, public_key BLOB NOT NULL);
INSERT INTO devices (id, name, ip, public_key) SELECT id, name, ip, '' FROM equipments;
DROP TABLE equipments;

DROP TABLE equipment_identification_rules;
CREATE TABLE device_identification_rules (device_id INTEGER NOT NULL REFERENCES devices(id) ON DELETE CASCADE, identification_rule_id INTEGER NOT NULL REFERENCES identification_rules(id) ON DELETE CASCADE, UNIQUE(device_id, identification_rule_id));

CREATE TABLE device_actions (device_id INTEGER NOT NULL REFERENCES devices(id) ON DELETE CASCADE, action_id INTEGER NOT NULL REFERENCES actions(id) ON DELETE CASCADE, UNIQUE(device_id, action_id));
INSERT INTO device_actions SELECT equipment_id, action_id FROM equipment_actions;
DROP TABLE equipment_actions;

CREATE TABLE scripts (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, script TEXT NOT NULL);

CREATE TABLE script_parameters (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, script_id INTEGER NOT NULL REFERENCES scripts(id) ON DELETE CASCADE, type INTEGER NOT NULL, name TEXT NOT NULL);

CREATE TABLE script_instances (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, script_id INTEGER NOT NULL REFERENCES scripts(id) ON DELETE CASCADE);

CREATE TABLE text_script_parameters (script_parameter_id INTEGER NOT NULL REFERENCES script_parameters(id) ON DELETE CASCADE, script_instance_id INTEGER NOT NULL REFERENCES script_instances(id) ON DELETE CASCADE, sequence INTEGER NOT NULL, value TEXT NOT NULL);

CREATE TABLE integer_script_parameters (script_parameter_id INTEGER NOT NULL REFERENCES script_parameters(id) ON DELETE CASCADE, script_instance_id INTEGER NOT NULL REFERENCES script_instances(id) ON DELETE CASCADE, sequence INTEGER NOT NULL, value INTEGER NOT NULL);

CREATE TABLE portal_script_parameters (script_parameter_id INTEGER NOT NULL REFERENCES script_parameters(id) ON DELETE CASCADE, script_instance_id INTEGER NOT NULL REFERENCES script_instances(id) ON DELETE CASCADE, sequence INTEGER NOT NULL, value INTEGER NOT NULL REFERENCES portals(id) ON DELETE CASCADE);

INSERT INTO scripts VALUES(1, 'biometry');
INSERT INTO script_parameters VALUES(1, 1, 2, 'portal');

INSERT INTO scripts VALUES(2, 'card');
INSERT INTO script_parameters VALUES(2, 2, 2, 'portal_in');
INSERT INTO script_parameters VALUES(3, 2, 2, 'portal_out');
INSERT INTO script_parameters VALUES(4, 2, 1, 'identifier_source');

INSERT INTO scripts VALUES(3, 'password');
INSERT INTO script_parameters VALUES(5, 3, 2, 'portal');

INSERT INTO script_instances VALUES(1, 1);
INSERT INTO portal_script_parameters VALUES(1, 1, 0, -1);

INSERT INTO script_instances VALUES(2, 2);
INSERT INTO portal_script_parameters VALUES(2, 2, 0, -1);
INSERT INTO portal_script_parameters VALUES(3, 2, 0, -2);
INSERT INTO text_script_parameters VALUES(4, 2, 0, 'mag');
INSERT INTO text_script_parameters VALUES(4, 2, 0, 'win');

INSERT INTO script_instances VALUES(3, 3);
INSERT INTO portal_script_parameters VALUES(5, 3, 0, -1);

INSERT INTO identification_rules VALUES(1, 'Biometry', 1);
INSERT INTO identification_rules VALUES(2, 'Card', 2);
INSERT INTO identification_rules VALUES(3, 'Password', 3);

INSERT INTO device_identification_rules SELECT id, 1 FROM devices;
INSERT INTO device_identification_rules SELECT id, 2 FROM devices;
INSERT INTO device_identification_rules SELECT id, 3 FROM devices;

--from 2.5.0
--from 2.5.1
--from 2.5.2
--from 2.5.3

CREATE TABLE new_portals (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, name TEXT NOT NULL, area_from_id INTEGER NOT NULL REFERENCES areas(id), area_to_id INTEGER NOT NULL REFERENCES areas(id));
INSERT INTO new_portals (id, name, area_from_id, area_to_id) SELECT id, name, area_from_id, area_to_id FROM portals;
DROP TABLE portals;
ALTER TABLE new_portals RENAME TO portals;

CREATE TRIGGER cascade_delete_device BEFORE DELETE ON devices BEGIN DELETE FROM access_rules WHERE id IN ( SELECT ar.id FROM access_rules AS ar JOIN portal_access_rules AS par ON ar.id = par.access_rule_id JOIN portal_script_parameters AS psp ON par.portal_id = psp.value JOIN identification_rules AS ir ON psp.script_instance_id = ir.script_instance_id JOIN device_identification_rules AS dir ON ir.id = dir.identification_rule_id WHERE dir.device_id = OLD.id ); DELETE FROM portals WHERE id IN ( SELECT p.id FROM portals AS p JOIN portal_script_parameters AS psp ON p.id = psp.value JOIN identification_rules AS ir ON psp.script_instance_id = ir.script_instance_id JOIN device_identification_rules AS dir ON ir.id = dir.identification_rule_id WHERE dir.device_id = OLD.id ); DELETE FROM script_instances WHERE id IN ( SELECT si.id FROM script_instances AS si JOIN identification_rules AS ir ON si.id = ir.script_instance_id JOIN device_identification_rules AS dir ON ir.id = dir.identification_rule_id WHERE dir.device_id = OLD.id ); END;

--from 2.5.4
--from 2.5.5
--from 2.5.6
--from 2.5.7
--from 2.5.8
--from 2.5.9
--from 2.5.10
--from 2.5.11
--from 2.5.12
--from 2.5.13
--from 2.5.14
--from 2.5.15

CREATE TABLE c_users (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, user_id INTEGER NOT NULL REFERENCES users(id) ON DELETE CASCADE ON UPDATE CASCADE, column_1 TEXT);

--from 2.5.16
--from 2.5.17
--from 2.5.18

CREATE TABLE api_logins (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, user_id INTEGER UNIQUE NOT NULL REFERENCES users(id) ON DELETE CASCADE ON UPDATE CASCADE, login TEXT UNIQUE NOT NULL, password TEXT, salt TEXT);

CREATE TABLE api_access_levels (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, name TEXT NOT NULL);

CREATE TABLE api_login_api_access_levels (api_login_id INTEGER NOT NULL REFERENCES api_logins(id) ON DELETE CASCADE, api_access_level_id INTEGER NOT NULL REFERENCES api_access_levels(id) ON DELETE CASCADE, UNIQUE(api_login_id, api_access_level_id));

CREATE TABLE api_commands (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, api_access_level_id INTEGER NOT NULL REFERENCES api_access_levels(id) ON DELETE CASCADE, name TEXT NOT NULL);

CREATE TABLE api_object_commands (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, api_command_id INTEGER NOT NULL REFERENCES api_commands(id) ON DELETE CASCADE, name TEXT NOT NULL);

CREATE TABLE api_object_field_commands (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, api_object_command_id INTEGER NOT NULL REFERENCES api_object_commands(id) ON DELETE CASCADE, name TEXT NOT NULL);

CREATE TABLE api_object_field_command_values (api_object_field_command_id INTEGER NOT NULL REFERENCES api_object_field_commands(id) ON DELETE CASCADE, value BIGINT NOT NULL);

--from 2.5.19
--from 2.5.20
--from 2.5.21
--from 2.5.22

CREATE TABLE new_device_identification_rules (device_id INTEGER NOT NULL REFERENCES devices(id) ON DELETE CASCADE ON UPDATE CASCADE, identification_rule_id INTEGER NOT NULL REFERENCES identification_rules(id) ON DELETE CASCADE, UNIQUE(device_id, identification_rule_id));
INSERT INTO new_device_identification_rules (device_id, identification_rule_id) SELECT device_id, identification_rule_id FROM device_identification_rules;
DROP TABLE device_identification_rules;
ALTER TABLE new_device_identification_rules RENAME TO device_identification_rules;

CREATE TABLE new_device_actions (device_id INTEGER NOT NULL REFERENCES devices(id) ON DELETE CASCADE ON UPDATE CASCADE, action_id INTEGER NOT NULL REFERENCES actions(id) ON DELETE CASCADE, UNIQUE(device_id, action_id));
INSERT INTO new_device_actions (device_id, action_id) SELECT device_id, action_id FROM device_actions;
DROP TABLE device_actions;
ALTER TABLE new_device_actions RENAME TO device_actions;

CREATE TABLE new_devices (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, name TEXT NOT NULL, ip TEXT NOT NULL, public_key BLOB);
INSERT INTO new_devices (id, name, ip, public_key) SELECT id, name, ip, public_key FROM devices;
DROP TABLE devices;
ALTER TABLE new_devices RENAME TO devices;

--from 2.5.23
--from 2.5.24
--from 2.6.0
--from 2.6.1
--from 2.6.2
--from 2.6.3
--from 2.6.4
--from 2.6.5
--from 2.6.6
--from 2.6.7
--from 2.6.8
--from 2.6.9
--from 2.6.10
--from 2.6.11
--from 2.6.12

CREATE TABLE visits (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, visitor_id BIGINT, host_id BIGINT, begin_time INTEGER NOT NULL, end_time INTEGER NOT NULL);

CREATE TABLE c_visits (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, visit_id INTEGER NOT NULL REFERENCES visits(id) ON DELETE CASCADE);

CREATE TABLE custom_tables (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, table_name TEXT NOT NULL, name TEXT NOT NULL);

CREATE TABLE custom_columns (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, custom_table_id INTEGER NOT NULL REFERENCES custom_tables(id) ON DELETE CASCADE, column_name TEXT NOT NULL, name TEXT NOT NULL);

CREATE TABLE user_types (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, custom_table_id INTEGER NOT NULL REFERENCES custom_tables(id) ON DELETE CASCADE, require_visitor INTEGER DEFAULT (0));

ALTER TABLE users ADD COLUMN user_type_id INTEGER REFERENCES user_types(id) ON DELETE SET NULL;

CREATE TABLE new_c_users (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, user_id INTEGER NOT NULL REFERENCES users(id) ON DELETE CASCADE, cpf TEXT);
INSERT INTO new_c_users (id, user_id, cpf) SELECT id, user_id, column_1 FROM c_users;
DROP TABLE c_users;
ALTER TABLE new_c_users RENAME TO c_users;

CREATE TABLE _visitors (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, user_id INTEGER NOT NULL REFERENCES users(id) ON DELETE CASCADE);

INSERT INTO custom_tables VALUES(1, 'c_users', 'Usuários');
INSERT INTO custom_tables VALUES(2, 'c_visits', 'Visitas');
INSERT INTO custom_tables VALUES(3, '_visitors', 'Visitantes');
INSERT INTO custom_columns VALUES(1, 1, 'cpf', 'CPF');

INSERT INTO user_types VALUES(1, 3, 1);

UPDATE users SET user_type_id = 1 WHERE id IN (SELECT id FROM users JOIN user_roles ON users.id = user_roles.user_id WHERE role = 2);
DELETE FROM user_roles WHERE role = 2;

--from 2.8.0

ALTER TABLE visits ADD COLUMN finished INTEGER DEFAULT 0;

--from 2.8.1
--from 2.8.2
--from 2.8.3
--from 2.8.4
--from 2.8.5
--from 2.8.6
--from 2.8.7

INSERT INTO scripts VALUES(4, 'user_identified');
INSERT INTO script_parameters VALUES(6, 4, 2, 'portal');
INSERT INTO script_instances(script_id) SELECT 4 AS script_id FROM devices;
INSERT INTO portal_script_parameters(script_parameter_id, script_instance_id, sequence, value) SELECT 6 script_parameter_id, t2.id script_instance_id, 0 sequence, t1.id value FROM (SELECT (SELECT count(0) FROM portals pt1 WHERE pt1.id >= pt2.id) AS row, pt2.id FROM portals pt2 ORDER BY id DESC) t1 join (SELECT (SELECT count(0) FROM script_instances st1 WHERE st1.id >= st2.id) AS row, st2.id FROM script_instances st2 ORDER BY id DESC limit (SELECT count(*) FROM portals)) t2 ON t1.row = t2.row;
INSERT INTO identification_rules(name, script_instance_id) SELECT "User Identified" name, id script_instance_id FROM script_instances ORDER BY id DESC limit (SELECT count(*) FROM portals);

--from 2.8.8
--from 2.8.9
--from 2.8.10
--from 3.0.0

UPDATE actions SET parameters = parameters || ', reason=1';
DROP TRIGGER cascade_delete_device;
CREATE TRIGGER cascade_delete_device_clients BEFORE DELETE ON device_clients BEGIN DELETE FROM access_rules WHERE id IN ( SELECT ar.id FROM access_rules AS ar JOIN portal_access_rules AS par ON ar.id = par.access_rule_id JOIN portal_script_parameters AS psp ON par.portal_id = psp.value JOIN identification_rules AS ir ON psp.script_instance_id = ir.script_instance_id JOIN device_identification_rules AS dir ON ir.id = dir.identification_rule_id WHERE dir.device_id = OLD.client_id); DELETE FROM portals WHERE id IN ( SELECT p.id FROM portals AS p JOIN portal_script_parameters AS psp ON p.id = psp.value JOIN identification_rules AS ir ON psp.script_instance_id = ir.script_instance_id JOIN device_identification_rules AS dir ON ir.id = dir.identification_rule_id WHERE dir.device_id = OLD.client_id); DELETE FROM script_instances WHERE id IN ( SELECT si.id FROM script_instances AS si JOIN identification_rules AS ir ON si.id = ir.script_instance_id JOIN device_identification_rules AS dir ON ir.id = dir.identification_rule_id WHERE dir.device_id = OLD.client_id); END;

--from 3.0.1

DROP TRIGGER cascade_delete_device_clients;
CREATE TRIGGER cascade_delete_device_clients BEFORE DELETE ON device_clients BEGIN DELETE FROM device_identification_rules WHERE device_id = OLD.client_id; DELETE FROM device_actions WHERE device_id = OLD.client_id; END;

--from 3.0.2
--from 3.2.0
--from 3.2.1
--from 3.2.2
--from 3.2.3

DROP TRIGGER cascade_delete_device_clients;
CREATE TRIGGER cascade_delete_device_clients BEFORE DELETE ON device_clients BEGIN DELETE FROM access_rules WHERE id IN ( SELECT ar.id FROM access_rules AS ar JOIN portal_access_rules AS par ON ar.id = par.access_rule_id JOIN portal_script_parameters AS psp ON par.portal_id = psp.value JOIN identification_rules AS ir ON psp.script_instance_id = ir.script_instance_id JOIN device_identification_rules AS dir ON ir.id = dir.identification_rule_id WHERE dir.device_id = OLD.client_id); DELETE FROM portals WHERE id IN ( SELECT p.id FROM portals AS p JOIN portal_script_parameters AS psp ON p.id = psp.value JOIN identification_rules AS ir ON psp.script_instance_id = ir.script_instance_id JOIN device_identification_rules AS dir ON ir.id = dir.identification_rule_id WHERE dir.device_id = OLD.client_id); DELETE FROM script_instances WHERE id IN ( SELECT si.id FROM script_instances AS si JOIN identification_rules AS ir ON si.id = ir.script_instance_id JOIN device_identification_rules AS dir ON ir.id = dir.identification_rule_id WHERE dir.device_id = OLD.client_id); END;

--from 3.2.4
--from 3.2.5
--from 3.4.0
--from 3.4.1
--from 3.4.2
--from 3.6.0

CREATE TABLE sec_boxs ( id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, name TEXT NOT NULL, version INTEGER NOT NULL, enabled INTEGER NOT NULL, relay_timeout INTEGER NOT NULL, door_sensor_enabled INTEGER NOT NULL, door_sensor_idle INTEGER NOT NULL);

--from 3.6.1
--from 3.6.2
--from 3.6.3
--from 3.6.4
--from 3.6.5
--from 3.6.6
--from 3.6.7
--from 3.6.8
--from 3.6.9
--from 3.6.10
--from 3.6.11
--from 3.6.12
--from 3.7.0
--from 3.7.1
--from 3.7.2
--from 3.7.3
--from 3.7.4
--from 4.0.0
--from 4.0.1
--from 4.0.2
--from 4.0.3
--from 4.0.4
--from 4.0.5
--from 4.0.6
--from 4.0.7
--from 4.0.8
--from 4.0.9
--from 4.0.10
--from 4.1.0
--from 4.1.1
--from 4.1.2
--from 4.1.3
--from 4.1.4
--from 4.1.5
--from 4.1.6
--from 4.2.0
--from 4.2.1
--from 4.2.2
--from 4.2.3

CREATE TABLE catra_infos ( id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, left_turns BIGINT NOT NULL, right_turns BIGINT NOT NULL, entrance_turns BIGINT NOT NULL, exit_turns BIGINT NOT NULL);
INSERT INTO catra_infos VALUES(1, 0, 0, 0, 0);

--from 4.2.4

CREATE TABLE holidays (	id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, name TEXT NOT NULL, hol1 INTEGER NOT NULL, hol2 INTEGER NOT NULL, hol3 INTEGER NOT NULL, start INTEGER NOT NULL, end INTEGER NOT NULL, repeats INTEGER NOT NULL);
ALTER TABLE time_spans ADD COLUMN hol1 INTEGER NOT NULL DEFAULT 1;
ALTER TABLE time_spans ADD COLUMN hol2 INTEGER NOT NULL DEFAULT 1;
ALTER TABLE time_spans ADD COLUMN hol3 INTEGER NOT NULL DEFAULT 1;

--from 4.4.0
--from 4.4.1

ALTER TABLE access_logs ADD COLUMN card_value BIGINT DEFAULT 0;
CREATE TABLE contingency_cards ( id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, value BIGINT UNIQUE NOT NULL);
CREATE TABLE contingency_card_access_rules ( access_rule_id INTEGER NOT NULL REFERENCES access_rules(id) ON DELETE CASCADE);
INSERT INTO contingency_card_access_rules VALUES(1);

--from 4.4.2
--from 4.4.3

CREATE TABLE log_types (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, name TEXT NOT NULL );

--from 4.6.0
--from 4.6.1
--from 4.6.2
--from 4.6.3
--from 4.6.4
--from 4.6.5
--from 4.6.6
--from 4.6.7
--from 4.6.8
--from 4.6.9
--from 4.6.10
--from 4.6.11
--from 4.6.12

ALTER TABLE access_logs ADD COLUMN log_type_id BIGINT DEFAULT -1;
INSERT INTO identification_rules VALUES(5,'Card and Biometry',5);
INSERT INTO identification_rules VALUES(6,'Biometry and Card',6);
INSERT INTO scripts VALUES(5, 'card_biometry_idflex');
INSERT INTO script_parameters VALUES(4, 5, 2, 'portal');
INSERT INTO script_instances VALUES(5,5);
INSERT INTO scripts VALUES(6, 'biometry_card_idflex');
INSERT INTO script_parameters VALUES(5, 6, 2, 'portal');
INSERT INTO script_instances VALUES(6,6);
INSERT INTO portal_script_parameters VALUES(4, 5, 0, 1);
INSERT INTO portal_script_parameters VALUES(5, 6, 0, 1);

--from 4.6.13
--from 4.6.14

ALTER TABLE users ADD COLUMN begin_time INTEGER;
ALTER TABLE users ADD COLUMN end_time INTEGER;

--from 4.8.0
--from 4.8.1
--from 4.8.2
--from 4.8.3
--from 4.8.4
--from 4.10.0
--from 4.10.1
--from 4.10.2
--from 4.10.3
--from 4.10.4
--from 4.10.5
--from 4.10.6
--from 4.10.7
--from 4.10.8
--from 4.10.9
--from 4.10.10

ALTER TABLE sec_boxs ADD COLUMN auto_close_enabled INTEGER NOT NULL DEFAULT 0;
CREATE TABLE opening_times (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, user_id INTEGER NOT NULL REFERENCES users(id) ON DELETE CASCADE ON UPDATE CASCADE, door_id BIGINT NOT NULL, time INTEGER NOT NULL);

--from 4.10.11
--from 4.10.12
--from 4.10.13
--from 4.10.14
--from 4.10.15
--from 4.10.16
--from 4.10.17
--from 4.10.18
--from 4.10.19
--from 4.11.0
--from 4.12.0
--from 4.12.1
--from 4.12.2
--from 4.12.3
--from 4.12.4
--from 4.12.5
--from 4.12.6
--from 4.12.7
--from 4.12.8
--from 4.12.9

--from 5.0.0
--from 5.0.1
--from 5.0.2
--from 5.0.3
--from 5.0.4
--from 5.0.5
--from 5.0.6
--from 5.0.7
--from 5.0.8
--from 5.0.9
--from 5.2.0
--from 5.2.1
--from 5.2.2
--from 5.2.3
--from 5.2.4
--from 5.2.5
--from 5.2.6
--from 5.2.7

CREATE TRIGGER replicate_changes_on_default_sec_box BEFORE UPDATE ON sec_boxs WHEN OLD.id = 65793 BEGIN UPDATE sec_boxs set relay_timeout = NEW.relay_timeout, door_sensor_enabled = NEW.door_sensor_enabled, door_sensor_idle = NEW.door_sensor_idle, auto_close_enabled = NEW.auto_close_enabled WHERE id <> OLD.id; END;

--from 5.2.8
--from 5.2.9
--from 5.2.10
--from 5.2.11
--from 5.2.12
--from 5.2.13
--from 5.2.14
--from 5.2.15
--from 5.2.16
--from 5.2.17
--from 5.2.18
--from 5.2.19
--from 5.2.20
--from 5.2.21
--from 5.2.22
--from 5.2.23
--from 5.2.24
--from 5.2.25
--from 5.2.26
--from 5.2.27
--from 5.2.28
--from 5.2.29
--from 5.2.30
--from 5.2.31
--from 5.2.32
--from 5.2.33
--from 5.2.34
--from 5.2.35
--from 5.2.36

ALTER TABLE users ADD COLUMN secret TEXT;

--from 5.2.37

ALTER TABLE alarm_logs ADD COLUMN access_log_id BIGINT NOT NULL DEFAULT 0;

--from 5.2.38
--from 5.2.39

ALTER TABLE cards ADD COLUMN secret TEXT;
CREATE TABLE users_backup (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, registration TEXT NOT NULL, name TEXT NOT NULL, password TEXT, salt TEXT, expires INTEGER, user_type_id INTEGER REFERENCES user_types(id) ON DELETE SET NULL, begin_time INTEGER, end_time INTEGER);
INSERT INTO users_backup SELECT id, registration, name, password, salt, expires, user_type_id, begin_time, end_time FROM users;
DROP TABLE users;
ALTER TABLE users_backup RENAME TO users;

--from 5.2.40
--from 5.2.41
--from 5.2.42
--from 5.2.43
--from 5.2.44
--from 5.2.45
--from 5.2.46
--from 5.2.47
--from 5.2.48
--from 5.2.49
--from 5.2.50
--from 5.2.51
--from 5.2.52
--from 5.2.53
--from 5.2.54
--from 5.2.55
--from 5.2.56
--from 5.2.57
--from 5.2.58
--from 5.2.59
--from 5.2.60
--from 5.2.61
--from 5.2.62
--from 5.2.63
--from 5.2.64
--from 5.2.65
--from 5.2.66
--from 5.3.0
--from 5.4.0
--from 5.4.1
--from 5.5.0
--from 5.5.1
--from 5.5.2
--from 5.5.3
--from 5.5.4

UPDATE report_column_formats SET width = 15 WHERE width = 5;
UPDATE report_column_formats SET width = 2 WHERE id IN (2, 9, 16, 22);
UPDATE report_column_formats SET adjustment = 2 WHERE id IN (2, 9, 16, 22);

--from 5.5.5
--from 5.5.6
--from 5.5.7
--from 5.5.8
--from 5.5.9
--from 5.5.10

CREATE TABLE change_logs (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, operation_type TEXT NOT NULL, table_name TEXT NOT NULL, table_id INTEGER NOT NULL, timestamp INTEGER);
CREATE TRIGGER log_users_on_insert AFTER INSERT ON users BEGIN INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("insert", "users", NEW.id, STRFTIME('%s','now')); END;
CREATE TRIGGER log_users_on_update AFTER UPDATE ON users BEGIN INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("update", "users", NEW.id, STRFTIME('%s','now')); END;
CREATE TRIGGER log_users_on_delete AFTER DELETE ON users BEGIN INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("delete", "users", OLD.id, STRFTIME('%s','now')); END;
CREATE TRIGGER log_templates_on_insert AFTER INSERT ON templates BEGIN INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("insert", "templates", NEW.id, STRFTIME('%s','now')); END;
CREATE TRIGGER log_templates_on_update AFTER UPDATE ON templates BEGIN INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("update", "templates", NEW.id, STRFTIME('%s','now')); END;
CREATE TRIGGER log_templates_on_delete AFTER DELETE ON templates BEGIN INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("delete", "templates", OLD.id, STRFTIME('%s','now')); END;
CREATE TRIGGER log_cards_on_insert AFTER INSERT ON cards BEGIN INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("insert", "cards", NEW.id, STRFTIME('%s','now')); END;
CREATE TRIGGER log_cards_on_update AFTER UPDATE ON cards BEGIN INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("update", "cards", NEW.id, STRFTIME('%s','now')); END;
CREATE TRIGGER log_cards_on_delete AFTER DELETE ON cards BEGIN INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("delete", "cards", OLD.id, STRFTIME('%s','now')); END;
DROP TRIGGER IF EXISTS prevent_update_default_time_zone;
CREATE TRIGGER prevent_update_default_time_zone BEFORE UPDATE ON time_zones WHEN OLD.id <> NEW.id BEGIN SELECT RAISE(IGNORE); END;

--from 5.5.11
--from 5.5.12
--from 5.5.13

INSERT INTO reports VALUES(6,'Alarmes (Global)','','alarm_logs','Data e Hora (Logs de Alarme);Evento (Logs de Alarme);Causa (Logs de Alarme);Código (Usuário);Nome (Usuário);Matrícula (Usuário)',';','\r\n');
INSERT INTO report_columns VALUES(33,6,3,0);
INSERT INTO report_columns VALUES(34,6,3,1);
INSERT INTO report_columns VALUES(35,6,3,2);
INSERT INTO report_columns VALUES(36,6,3,3);
INSERT INTO report_columns VALUES(37,6,3,4);
INSERT INTO report_columns VALUES(38,6,3,5);
INSERT INTO object_field_report_columns VALUES(33,33,'alarm_logs','time');
INSERT INTO object_field_report_columns VALUES(34,34,'alarm_logs','event');
INSERT INTO object_field_report_columns VALUES(35,35,'alarm_logs','cause');
INSERT INTO object_field_report_columns VALUES(36,36,'users','id');
INSERT INTO object_field_report_columns VALUES(37,37,'users','name');
INSERT INTO object_field_report_columns VALUES(38,38,'users','registration');
INSERT INTO report_column_formats VALUES(33,33,0,0,'0','%d/%m/%Y %H:%M:%S');
INSERT INTO report_column_formats VALUES(34,34,1,1,' ','');
INSERT INTO report_column_formats VALUES(35,35,2,2,'0','');
INSERT INTO report_column_formats VALUES(36,36,2,15,'0','');
INSERT INTO report_column_formats VALUES(37,37,1,50,' ','');
INSERT INTO report_column_formats VALUES(38,38,1,50,' ','');
INSERT INTO report_filters VALUES(29,6,'alarm_logs','time','{"type":"day","interval":29,"finish":0}',1,1);
INSERT INTO report_filters VALUES(30,6,'alarm_logs','event','',1,1);
INSERT INTO report_filters VALUES(31,6,'alarm_logs','cause','',1,1);
ALTER TABLE access_logs ADD COLUMN qrcode_value TEXT;
CREATE TABLE qrcodes (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, value TEXT UNIQUE NOT NULL, user_id INTEGER NOT NULL REFERENCES users(id) ON DELETE CASCADE ON UPDATE CASCADE);
CREATE INDEX qrcodes_user_id_idx ON qrcodes(user_id);
CREATE TRIGGER log_qrcodes_on_insert AFTER INSERT ON qrcodes BEGIN INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("insert", "qrcodes", NEW.id, STRFTIME('%s', 'now')); END;
CREATE TRIGGER log_qrcodes_on_update AFTER UPDATE ON qrcodes BEGIN INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("update", "qrcodes", NEW.id, STRFTIME('%s', 'now')); END;
CREATE TRIGGER log_qrcodes_on_delete AFTER DELETE ON qrcodes BEGIN INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("delete", "qrcodes", OLD.id, STRFTIME('%s', 'now')); END;
INSERT INTO device_identification_rules SELECT device_id, 7 FROM device_identification_rules WHERE identification_rule_id = 1
INSERT INTO identification_rules SELECT 7, "QR Code para dispositivo " || name, 7 FROM devices WHERE id = (SELECT device_id FROM device_identification_rules WHERE identification_rule_id = 1)
--Algumas alteracoes sao especificas entre iDBlockV2, iDFit, iDAcess e entre iDFlex, iDAccess Nano e Pro.

--from 5.6.0
--from 5.6.1
--from 5.6.2
--from 5.6.3
--from 5.6.4
--from 5.6.5
--from 5.6.6
--from 5.6.7
--from 5.6.8
--from 5.7.0
--from 5.7.1
--from 5.7.2
--from 5.7.3
--from 5.7.4

DROP TRIGGER log_users_on_update;
CREATE TRIGGER log_users_on_updated_id AFTER UPDATE ON users WHEN NEW.id <> OLD.id BEGIN INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("delete", "users", OLD.id, STRFTIME('%s','now')); INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("insert", "users", NEW.id, STRFTIME('%s','now')); END;
CREATE TRIGGER log_users_on_update AFTER UPDATE ON users WHEN NEW.id = OLD.id BEGIN INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("update", "users", NEW.id, STRFTIME('%s','now')); END;

--from 5.7.5

CREATE TABLE change_logs_backup (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, operation_type TEXT NOT NULL, table_name TEXT NOT NULL, table_id BIGINT NOT NULL, timestamp INTEGER);
INSERT INTO change_logs_backup SELECT id, operation_type, table_name, table_id, timestamp FROM change_logs;
DROP TABLE change_logs;
ALTER TABLE change_logs_backup RENAME TO change_logs;

--from 5.8.0
--from 5.8.1
--from 5.8.2
--from 5.8.3

CREATE TABLE timed_alarms (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, name TEXT NOT NULL, time INTEGER NOT NULL, sun INTEGER NOT NULL, mon INTEGER NOT NULL, tue INTEGER NOT NULL, wed INTEGER NOT NULL, thu INTEGER NOT NULL, fri INTEGER NOT NULL, sat INTEGER NOT NULL);

--from 5.8.4
--from 5.8.5
--from 5.8.6
--from 5.8.7
--from 5.8.8
--from 5.8.9

ALTER TABLE alarm_logs ADD COLUMN door_id INTEGER NOT NULL DEFAULT 0;

INSERT INTO reports VALUES(7,'Ponto (Global)','','access_logs','Data e Hora (Logs de Acesso);ID de Batida;Tipo de Batida;Autorização (Logs de Acesso);Identificação;Código (Usuário);Nome (Usuário);Matrícula (Usuário);Nome (Portal);Nome (Horário)',';','\r\n');
INSERT INTO reports VALUES(8,'Ponto por Usuário','','access_logs','Data e Hora (Logs de Acesso);ID de Batida;Tipo de Batida;Autorização (Logs de Acesso);Identificação;Código (Usuário);Nome (Usuário);Matrícula (Usuário);Nome (Portal);Nome (Horário)',';','\r\n');
INSERT INTO reports VALUES(9,'Ponto por Horário','','access_logs','Data e Hora (Logs de Acesso);ID de Batida;Tipo de Batida;Autorização (Logs de Acesso);Identificação;Código (Usuário);Nome (Usuário);Matrícula (Usuário);Nome (Horário)',';','\r\n');
INSERT INTO reports VALUES(10,'Ponto por Departamento','','access_logs','Data e Hora (Logs de Acesso);ID de Batida;Tipo de Batida;Autorização (Logs de Acesso);Identificação;Código (Usuário);Nome (Usuário);Matrícula (Usuário);Nome (Portal);Nome (Horário)',';','\r\n');

INSERT INTO report_columns VALUES(43,7,3,0);
INSERT INTO report_columns VALUES(44,7,3,1);
INSERT INTO report_columns VALUES(45,7,3,2);
INSERT INTO report_columns VALUES(46,7,3,3);
INSERT INTO report_columns VALUES(47,7,3,4);
INSERT INTO report_columns VALUES(48,7,3,5);
INSERT INTO report_columns VALUES(49,7,3,6);
INSERT INTO report_columns VALUES(50,7,3,7);
INSERT INTO report_columns VALUES(51,7,3,8);
INSERT INTO report_columns VALUES(52,8,3,9);
INSERT INTO report_columns VALUES(53,8,3,0);
INSERT INTO report_columns VALUES(54,8,3,1);
INSERT INTO report_columns VALUES(55,8,3,2);
INSERT INTO report_columns VALUES(56,8,3,3);
INSERT INTO report_columns VALUES(57,8,3,4);
INSERT INTO report_columns VALUES(58,8,3,5);
INSERT INTO report_columns VALUES(59,8,3,6);
INSERT INTO report_columns VALUES(60,8,3,7);
INSERT INTO report_columns VALUES(61,8,3,8);
INSERT INTO report_columns VALUES(62,9,3,9);
INSERT INTO report_columns VALUES(63,9,3,0);
INSERT INTO report_columns VALUES(64,9,3,1);
INSERT INTO report_columns VALUES(65,9,3,2);
INSERT INTO report_columns VALUES(66,9,3,3);
INSERT INTO report_columns VALUES(67,9,3,4);
INSERT INTO report_columns VALUES(68,9,3,5);
INSERT INTO report_columns VALUES(69,9,3,6);
INSERT INTO report_columns VALUES(70,9,3,7);
INSERT INTO report_columns VALUES(71,10,3,8);
INSERT INTO report_columns VALUES(72,10,3,0);
INSERT INTO report_columns VALUES(73,10,3,1);
INSERT INTO report_columns VALUES(74,10,3,2);
INSERT INTO report_columns VALUES(75,10,3,3);
INSERT INTO report_columns VALUES(76,10,3,4);
INSERT INTO report_columns VALUES(77,10,3,5);
INSERT INTO report_columns VALUES(78,10,3,6);
INSERT INTO report_columns VALUES(79,10,3,7);
INSERT INTO report_columns VALUES(80,10,3,8);
INSERT INTO report_columns VALUES(81,10,3,9);

INSERT INTO object_field_report_columns VALUES(43,43,'access_logs','time');
INSERT INTO object_field_report_columns VALUES(44,44,'log_types','id');
INSERT INTO object_field_report_columns VALUES(45,45,'log_types','name');
INSERT INTO object_field_report_columns VALUES(46,46,'access_logs','event');
INSERT INTO object_field_report_columns VALUES(47,47,'access_logs','identifier_id');
INSERT INTO object_field_report_columns VALUES(48,48,'users','id');
INSERT INTO object_field_report_columns VALUES(49,49,'users','name');
INSERT INTO object_field_report_columns VALUES(50,50,'users','registration');
INSERT INTO object_field_report_columns VALUES(51,51,'portals','name');
INSERT INTO object_field_report_columns VALUES(52,52,'time_zones','name');
INSERT INTO object_field_report_columns VALUES(53,53,'access_logs','time');
INSERT INTO object_field_report_columns VALUES(54,54,'log_types','id');
INSERT INTO object_field_report_columns VALUES(55,55,'log_types','name');
INSERT INTO object_field_report_columns VALUES(56,56,'access_logs','event');
INSERT INTO object_field_report_columns VALUES(57,57,'access_logs','identifier_id');
INSERT INTO object_field_report_columns VALUES(58,58,'users','id');
INSERT INTO object_field_report_columns VALUES(59,59,'users','name');
INSERT INTO object_field_report_columns VALUES(60,60,'users','registration');
INSERT INTO object_field_report_columns VALUES(61,61,'portals','name');
INSERT INTO object_field_report_columns VALUES(62,62,'time_zones','name');
INSERT INTO object_field_report_columns VALUES(63,63,'access_logs','time');
INSERT INTO object_field_report_columns VALUES(64,64,'log_types','id');
INSERT INTO object_field_report_columns VALUES(65,65,'log_types','name');
INSERT INTO object_field_report_columns VALUES(66,66,'access_logs','event');
INSERT INTO object_field_report_columns VALUES(67,67,'access_logs','identifier_id');
INSERT INTO object_field_report_columns VALUES(68,68,'users','id');
INSERT INTO object_field_report_columns VALUES(69,69,'users','name');
INSERT INTO object_field_report_columns VALUES(70,70,'users','registration');
INSERT INTO object_field_report_columns VALUES(71,71,'time_zones','name');
INSERT INTO object_field_report_columns VALUES(72,72,'access_logs','time');
INSERT INTO object_field_report_columns VALUES(73,73,'log_types','id');
INSERT INTO object_field_report_columns VALUES(74,74,'log_types','name');
INSERT INTO object_field_report_columns VALUES(75,75,'access_logs','event');
INSERT INTO object_field_report_columns VALUES(76,76,'access_logs','identifier_id');
INSERT INTO object_field_report_columns VALUES(77,77,'users','id');
INSERT INTO object_field_report_columns VALUES(78,78,'users','name');
INSERT INTO object_field_report_columns VALUES(79,79,'users','registration');
INSERT INTO object_field_report_columns VALUES(80,80,'portals','name');
INSERT INTO object_field_report_columns VALUES(81,81,'time_zones','name');

INSERT INTO report_column_formats VALUES(43,43,0,0,'0','%d/%m/%Y %H:%M:%S');
INSERT INTO report_column_formats VALUES(44,44,2,15,'0','');
INSERT INTO report_column_formats VALUES(45,45,1,50,' ','');
INSERT INTO report_column_formats VALUES(46,46,2,2,'0','');
INSERT INTO report_column_formats VALUES(47,47,1,1,' ','');
INSERT INTO report_column_formats VALUES(48,48,2,15,'0','');
INSERT INTO report_column_formats VALUES(49,49,1,50,' ','');
INSERT INTO report_column_formats VALUES(50,50,1,50,' ','');
INSERT INTO report_column_formats VALUES(51,51,1,50,' ','');
INSERT INTO report_column_formats VALUES(52,52,1,50,' ','');
INSERT INTO report_column_formats VALUES(53,53,0,0,'0','%d/%m/%Y %H:%M:%S');
INSERT INTO report_column_formats VALUES(54,54,2,15,'0','');
INSERT INTO report_column_formats VALUES(55,55,1,50,' ','');
INSERT INTO report_column_formats VALUES(56,56,2,2,'0','');
INSERT INTO report_column_formats VALUES(57,57,1,1,' ','');
INSERT INTO report_column_formats VALUES(58,58,2,15,'0','');
INSERT INTO report_column_formats VALUES(59,59,1,50,' ','');
INSERT INTO report_column_formats VALUES(60,60,1,50,' ','');
INSERT INTO report_column_formats VALUES(61,61,1,50,' ','');
INSERT INTO report_column_formats VALUES(62,62,1,50,' ','');
INSERT INTO report_column_formats VALUES(63,63,0,0,'0','%d/%m/%Y %H:%M:%S');
INSERT INTO report_column_formats VALUES(64,64,2,15,'0','');
INSERT INTO report_column_formats VALUES(65,65,1,50,' ','');
INSERT INTO report_column_formats VALUES(66,66,2,2,'0','');
INSERT INTO report_column_formats VALUES(67,67,1,1,' ','');
INSERT INTO report_column_formats VALUES(68,68,2,15,'0','');
INSERT INTO report_column_formats VALUES(69,69,1,50,' ','');
INSERT INTO report_column_formats VALUES(70,70,1,50,' ','');
INSERT INTO report_column_formats VALUES(71,71,1,50,' ','');
INSERT INTO report_column_formats VALUES(72,72,0,0,'0','%d/%m/%Y %H:%M:%S');
INSERT INTO report_column_formats VALUES(73,73,2,15,'0','');
INSERT INTO report_column_formats VALUES(74,74,1,50,' ','');
INSERT INTO report_column_formats VALUES(75,75,2,2,'0','');
INSERT INTO report_column_formats VALUES(76,76,1,1,' ','');
INSERT INTO report_column_formats VALUES(77,77,2,15,'0','');
INSERT INTO report_column_formats VALUES(78,78,1,50,' ','');
INSERT INTO report_column_formats VALUES(79,79,1,50,' ','');
INSERT INTO report_column_formats VALUES(80,80,1,50,' ','');
INSERT INTO report_column_formats VALUES(81,81,1,50,' ','');

INSERT INTO report_filters VALUES(32,7,'access_logs','time','{"type":"day","interval":29,"finish":0}',1,1);
INSERT INTO report_filters VALUES(33,7,'log_types','id','',1,1);
INSERT INTO report_filters VALUES(34,7,'users','id','',1,1);
INSERT INTO report_filters VALUES(35,7,'portals','id','',1,1);
INSERT INTO report_filters VALUES(36,7,'groups','id','',1,1);
INSERT INTO report_filters VALUES(37,7,'time_zones','id','',1,1);
INSERT INTO report_filters VALUES(38,8,'access_logs','event','',1,1);
INSERT INTO report_filters VALUES(39,8,'access_logs','time','{"type":"day","interval":29,"finish":0}',1,1);
INSERT INTO report_filters VALUES(40,8,'log_types','id','',1,1);
INSERT INTO report_filters VALUES(41,8,'users','id','',1,1);
INSERT INTO report_filters VALUES(42,8,'portals','id','',0,0);
INSERT INTO report_filters VALUES(43,8,'groups','id','',0,0);
INSERT INTO report_filters VALUES(44,8,'time_zones','id','',1,1);
INSERT INTO report_filters VALUES(45,9,'access_logs','event','',1,1);
INSERT INTO report_filters VALUES(46,9,'access_logs','time','{"type":"day","interval":29,"finish":0}',1,1);
INSERT INTO report_filters VALUES(47,9,'log_types','id','',1,1);
INSERT INTO report_filters VALUES(48,9,'users','id','',0,1);
INSERT INTO report_filters VALUES(49,9,'portals','id','',0,1);
INSERT INTO report_filters VALUES(50,9,'groups','id','',0,1);
INSERT INTO report_filters VALUES(51,9,'time_zones','id','',1,1);
INSERT INTO report_filters VALUES(52,10,'access_logs','event','',1,1);
INSERT INTO report_filters VALUES(53,10,'access_logs','time','{"type":"day","interval":29,"finish":0}',1,1);
INSERT INTO report_filters VALUES(54,10,'log_types','id','',1,1);
INSERT INTO report_filters VALUES(55,10,'users','id','',0,1);
INSERT INTO report_filters VALUES(56,10,'portals','id','',0,1);
INSERT INTO report_filters VALUES(57,10,'groups','id','',1,1);
INSERT INTO report_filters VALUES(58,10,'time_zones','id','',0,1);0INSERT INTO catra_infos VALUES(1, 0, 0, 0, 0);

DELETE FROM reports WHERE id >= 1 AND id <=4;
INSERT INTO reports VALUES(1,'Acessos (Global)','','access_logs','Data e Hora (Logs de Acesso);Autorização (Logs de Acesso);Identificação;Código (Usuário);Nome (Usuário);Matrícula (Usuário);Nome (Portal);Nome (Horário)',';','\r\n');
INSERT INTO reports VALUES(2,'Acessos por Usuário','','access_logs','Data e Hora (Logs de Acesso);Autorização (Logs de Acesso);Identificação;Código (Usuário);Nome (Usuário);Matrícula (Usuário);Nome (Portal);Nome (Horário)',';','\r\n');
INSERT INTO reports VALUES(3,'Acessos por Horário','','access_logs','Data e Hora (Logs de Acesso);Autorização (Logs de Acesso);Identificação;Código (Usuário);Nome (Usuário);Matrícula (Usuário);Nome (Horário)',';','\r\n');
INSERT INTO reports VALUES(4,'Acessos por Departamento','','access_logs','Data e Hora (Logs de Acesso);Autorização (Logs de Acesso);Identificação;Código (Usuário);Nome (Usuário);Matrícula (Usuário);Nome (Portal);Nome (Horário)',';','\r\n');

DELETE FROM report_columns WHERE id >= 1 AND id <=42;
INSERT INTO report_columns VALUES(1,1,3,0);
INSERT INTO report_columns VALUES(2,1,3,1);
INSERT INTO report_columns VALUES(3,1,3,2);
INSERT INTO report_columns VALUES(4,1,3,3);
INSERT INTO report_columns VALUES(5,1,3,4);
INSERT INTO report_columns VALUES(6,1,3,5);
INSERT INTO report_columns VALUES(7,1,3,6);
INSERT INTO report_columns VALUES(8,1,3,7);
INSERT INTO report_columns VALUES(9,2,3,0);
INSERT INTO report_columns VALUES(10,2,3,1);
INSERT INTO report_columns VALUES(11,2,3,2);
INSERT INTO report_columns VALUES(12,2,3,3);
INSERT INTO report_columns VALUES(13,2,3,4);
INSERT INTO report_columns VALUES(14,2,3,5);
INSERT INTO report_columns VALUES(15,2,3,6);
INSERT INTO report_columns VALUES(16,2,3,7);
INSERT INTO report_columns VALUES(17,3,3,0);
INSERT INTO report_columns VALUES(18,3,3,1);
INSERT INTO report_columns VALUES(19,3,3,2);
INSERT INTO report_columns VALUES(20,3,3,3);
INSERT INTO report_columns VALUES(21,3,3,4);
INSERT INTO report_columns VALUES(22,3,3,5);
INSERT INTO report_columns VALUES(23,3,3,6);
INSERT INTO report_columns VALUES(24,4,3,0);
INSERT INTO report_columns VALUES(25,4,3,1);
INSERT INTO report_columns VALUES(26,4,3,2);
INSERT INTO report_columns VALUES(27,4,3,3);
INSERT INTO report_columns VALUES(28,4,3,4);
INSERT INTO report_columns VALUES(29,4,3,5);
INSERT INTO report_columns VALUES(30,4,3,6);
INSERT INTO report_columns VALUES(31,4,3,7);
INSERT INTO report_columns VALUES(32,5,3,0);
INSERT INTO report_columns VALUES(33,5,3,1);
INSERT INTO report_columns VALUES(34,5,3,2);
INSERT INTO report_columns VALUES(35,5,3,3);
INSERT INTO report_columns VALUES(36,5,3,4);
INSERT INTO report_columns VALUES(37,6,3,0);
INSERT INTO report_columns VALUES(38,6,3,1);
INSERT INTO report_columns VALUES(39,6,3,2);
INSERT INTO report_columns VALUES(40,6,3,3);
INSERT INTO report_columns VALUES(41,6,3,4);
INSERT INTO report_columns VALUES(42,6,3,5);

DELETE FROM object_field_report_columns WHERE id >= 1 AND id <=42;
INSERT INTO object_field_report_columns VALUES(1,1,'access_logs','time');
INSERT INTO object_field_report_columns VALUES(2,2,'access_logs','event');
INSERT INTO object_field_report_columns VALUES(3,3,'access_logs','identifier_id');
INSERT INTO object_field_report_columns VALUES(4,4,'users','id');
INSERT INTO object_field_report_columns VALUES(5,5,'users','name');
INSERT INTO object_field_report_columns VALUES(6,6,'users','registration');
INSERT INTO object_field_report_columns VALUES(7,7,'portals','name');
INSERT INTO object_field_report_columns VALUES(8,8,'time_zones','name');
INSERT INTO object_field_report_columns VALUES(9,9,'access_logs','time');
INSERT INTO object_field_report_columns VALUES(10,10,'access_logs','event');
INSERT INTO object_field_report_columns VALUES(11,11,'access_logs','identifier_id');
INSERT INTO object_field_report_columns VALUES(12,12,'users','id');
INSERT INTO object_field_report_columns VALUES(13,13,'users','name');
INSERT INTO object_field_report_columns VALUES(14,14,'users','registration');
INSERT INTO object_field_report_columns VALUES(15,15,'portals','name');
INSERT INTO object_field_report_columns VALUES(16,16,'time_zones','name');
INSERT INTO object_field_report_columns VALUES(17,17,'access_logs','time');
INSERT INTO object_field_report_columns VALUES(18,18,'access_logs','event');
INSERT INTO object_field_report_columns VALUES(19,19,'access_logs','identifier_id');
INSERT INTO object_field_report_columns VALUES(20,20,'users','id');
INSERT INTO object_field_report_columns VALUES(21,21,'users','name');
INSERT INTO object_field_report_columns VALUES(22,22,'users','registration');
INSERT INTO object_field_report_columns VALUES(23,23,'time_zones','name');
INSERT INTO object_field_report_columns VALUES(24,24,'access_logs','time');
INSERT INTO object_field_report_columns VALUES(25,25,'access_logs','event');
INSERT INTO object_field_report_columns VALUES(26,26,'access_logs','identifier_id');
INSERT INTO object_field_report_columns VALUES(27,27,'users','id');
INSERT INTO object_field_report_columns VALUES(28,28,'users','name');
INSERT INTO object_field_report_columns VALUES(29,29,'users','registration');
INSERT INTO object_field_report_columns VALUES(30,30,'portals','name');
INSERT INTO object_field_report_columns VALUES(31,31,'time_zones','name');
INSERT INTO object_field_report_columns VALUES(32,32,'users','id');
INSERT INTO object_field_report_columns VALUES(33,33,'users','name');
INSERT INTO object_field_report_columns VALUES(34,34,'users','registration');
INSERT INTO object_field_report_columns VALUES(35,35,'groups','name');
INSERT INTO object_field_report_columns VALUES(36,36,'user_roles','role');
INSERT INTO object_field_report_columns VALUES(37,37,'alarm_logs','time');
INSERT INTO object_field_report_columns VALUES(38,38,'alarm_logs','event');
INSERT INTO object_field_report_columns VALUES(39,39,'alarm_logs','cause');
INSERT INTO object_field_report_columns VALUES(40,40,'users','id');
INSERT INTO object_field_report_columns VALUES(41,41,'users','name');
INSERT INTO object_field_report_columns VALUES(42,42,'users','registration');

DELETE FROM report_column_formats WHERE id >= 1 AND id <=42;
INSERT INTO report_column_formats VALUES(1,1,0,0,'0','%d/%m/%Y %H:%M:%S');
INSERT INTO report_column_formats VALUES(2,2,2,2,'0','');
INSERT INTO report_column_formats VALUES(3,3,1,1,' ','');
INSERT INTO report_column_formats VALUES(4,4,2,15,'0','');
INSERT INTO report_column_formats VALUES(5,5,1,50,' ','');
INSERT INTO report_column_formats VALUES(6,6,1,50,' ','');
INSERT INTO report_column_formats VALUES(7,7,1,50,' ','');
INSERT INTO report_column_formats VALUES(8,8,1,50,' ','');
INSERT INTO report_column_formats VALUES(9,9,0,0,'0','%d/%m/%Y %H:%M:%S');
INSERT INTO report_column_formats VALUES(10,10,2,2,'0','');
INSERT INTO report_column_formats VALUES(11,11,1,1,' ','');
INSERT INTO report_column_formats VALUES(12,12,2,15,'0','');
INSERT INTO report_column_formats VALUES(13,13,1,50,' ','');
INSERT INTO report_column_formats VALUES(14,14,1,50,' ','');
INSERT INTO report_column_formats VALUES(15,15,1,50,' ','');
INSERT INTO report_column_formats VALUES(16,16,1,50,' ','');
INSERT INTO report_column_formats VALUES(17,17,0,0,'0','%d/%m/%Y %H:%M:%S');
INSERT INTO report_column_formats VALUES(18,18,2,2,'0','');
INSERT INTO report_column_formats VALUES(19,19,1,1,' ','');
INSERT INTO report_column_formats VALUES(20,20,2,15,'0','');
INSERT INTO report_column_formats VALUES(21,21,1,50,' ','');
INSERT INTO report_column_formats VALUES(22,22,1,50,' ','');
INSERT INTO report_column_formats VALUES(23,23,1,50,' ','');
INSERT INTO report_column_formats VALUES(24,24,0,0,'0','%d/%m/%Y %H:%M:%S');
INSERT INTO report_column_formats VALUES(25,25,2,2,'0','');
INSERT INTO report_column_formats VALUES(26,26,1,1,' ','');
INSERT INTO report_column_formats VALUES(27,27,2,15,'0','');
INSERT INTO report_column_formats VALUES(28,28,1,50,' ','');
INSERT INTO report_column_formats VALUES(29,29,1,50,' ','');
INSERT INTO report_column_formats VALUES(30,30,1,50,' ','');
INSERT INTO report_column_formats VALUES(31,31,1,50,' ','');
INSERT INTO report_column_formats VALUES(32,32,2,15,'0','');
INSERT INTO report_column_formats VALUES(33,33,1,50,' ','');
INSERT INTO report_column_formats VALUES(34,34,1,50,' ','');
INSERT INTO report_column_formats VALUES(35,35,1,50,' ','');
INSERT INTO report_column_formats VALUES(36,36,1,1,' ','');
INSERT INTO report_column_formats VALUES(37,37,0,0,'0','%d/%m/%Y %H:%M:%S');
INSERT INTO report_column_formats VALUES(38,38,1,1,' ','');
INSERT INTO report_column_formats VALUES(39,39,2,2,'0','');
INSERT INTO report_column_formats VALUES(40,40,2,15,'0','');
INSERT INTO report_column_formats VALUES(41,41,1,50,' ','');
INSERT INTO report_column_formats VALUES(42,42,1,50,' ','');

ALTER TABLE access_logs ADD COLUMN pin_value TEXT;
CREATE TABLE pins (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, value TEXT UNIQUE NOT NULL, user_id INTEGER UNIQUE NOT NULL REFERENCES users(id) ON DELETE CASCADE ON UPDATE CASCADE);
CREATE INDEX pins_user_id_idx ON pins(user_id);
CREATE TRIGGER log_pins_on_insert AFTER INSERT ON pins BEGIN INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("insert", "pins", NEW.id, STRFTIME('%s','now')); END;
CREATE TRIGGER log_pins_on_update AFTER UPDATE ON pins BEGIN INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("update", "pins", NEW.id, STRFTIME('%s','now')); END;
CREATE TRIGGER log_pins_on_delete AFTER DELETE ON pins BEGIN INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("delete", "pins", OLD.id, STRFTIME('%s','now')); END;
INSERT INTO device_identification_rules SELECT device_id, 8 FROM device_identification_rules WHERE identification_rule_id = 1
INSERT INTO identification_rules SELECT 8, "PIN para dispositivo " || name, 8 FROM devices WHERE id = (SELECT device_id FROM device_identification_rules WHERE identification_rule_id = 1);
--Algumas alteracoes sao especificas entre iDBlockV2, iDFit, iDAcess e entre iDFlex, iDAccess Nano e Pro.

ALTER TABLE users ADD COLUMN last_access INTEGER;

--from 5.9.0

ALTER TABLE access_logs ADD COLUMN uhf_tag TEXT;
CREATE TABLE uhf_tags (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, value TEXT UNIQUE NOT NULL, user_id INTEGER NOT NULL REFERENCES users(id) ON DELETE CASCADE ON UPDATE CASCADE);
CREATE INDEX uhf_tags_user_id_idx ON uhf_tags(user_id);
CREATE TRIGGER log_uhf_tags_on_insert AFTER INSERT ON uhf_tags BEGIN INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("insert", "uhf_tags", NEW.id, STRFTIME('%s', 'now')); END;
CREATE TRIGGER log_uhf_tags_on_update AFTER UPDATE ON uhf_tags BEGIN INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("update", "uhf_tags", NEW.id, STRFTIME('%s', 'now')); END;
CREATE TRIGGER log_uhf_tags_on_delete AFTER DELETE ON uhf_tags BEGIN INSERT INTO change_logs (operation_type, table_name, table_id, timestamp) VALUES ("delete", "uhf_tags", OLD.id, STRFTIME('%s', 'now')); END;

CREATE TABLE access_events (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, event TEXT NOT NULL, type TEXT NOT NULL, identification TEXT NOT NULL, device_id BIGINT NOT NULL, timestamp INTEGER NOT NULL);
CREATE TABLE audit_logs (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, time TEXT NOT NULL, type INTEGER NOT NULL, details TEXT NOT NULL);
